-- SELECT * FROM employee
-- SELECT * FROM jobs
-- GO

---------------------------------------------------------------------------------------------------------------

--Just check for view existence
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS
         WHERE TABLE_NAME = 'employee_job')
   DROP VIEW employee_job
GO

--Create the view just to join two tables and make columns more meaningful (or hide the real table column names)
CREATE VIEW employee_job
AS
SELECT 
	fname AS FirstName, 
	lname AS LastName, 
	minit AS MiddleInitial,
	hire_date AS EmploymentStart,
	job_desc AS JobTitle, 
	job_lvl AS Job_Level,
	emp_id AS EmployeeID
FROM	employee e 
	JOIN jobs j ON e.job_id = j.job_id
GO

--Try the view out	
SELECT * FROM employee_job

--------------------------------------------------------------------------------------------------------------


--Try updating the view
UPDATE employee_job
SET JobTitle = 'Software Artist'
WHERE JobTitle = 'Designer'
GO
SELECT * FROM employee_job

--Just change the data back to how it was!
UPDATE employee_job
SET JobTitle = 'Designer' 
WHERE JobTitle = 'Software Artist'
GO
SELECT * FROM employee_job


--Note you cannot update more than 1 of the underlying tables at once without the use of triggers
UPDATE employee_job
SET JobTitle = 'Software Artist', Job_Level = 400
WHERE JobTitle = 'Designer'
GO


--------------------------------------------------------------------------------------------------------------

--try and create an index on this view
CREATE INDEX idx_EmployeeID
ON employee_job (EmployeeID)

--what about creating a Clustered Index on this view
CREATE UNIQUE CLUSTERED INDEX idx_EmployeeID
ON employee_job (EmployeeID)

--Just check for view existence
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS
         WHERE TABLE_NAME = 'employee_job')
   DROP VIEW employee_job
GO

--Create the view, now with SCHEMABINDING, note you need to specifcy dbo.tablename 

CREATE VIEW employee_job
WITH	SchemaBinding
AS
SELECT 
	fname AS FirstName, 
	lname AS LastName, 
	minit AS MiddleInitial,
	hire_date AS EmploymentStart,
	job_desc AS JobTitle, 
	job_lvl AS Job_Level,
	emp_id AS EmployeeID
FROM	dbo.employee e JOIN 
	dbo.jobs j ON e.job_id = j.job_id
GO

EXEC sp_spaceused employee_job

--try and create an index on this view
CREATE INDEX idx_EmployeeID
ON employee_job (EmployeeID)


--OK let's create a Clustered Index on this view
CREATE UNIQUE CLUSTERED INDEX idx_EmployeeID
ON employee_job (EmployeeID)
GO
EXEC sp_spaceused employee_job
GO

--Once the clustered index is created, then other indexes can be created
CREATE INDEX idx_jobtitle
ON employee_job (JobTitle)
EXEC sp_spaceused employee_job
GO

--------------------------------------------------------------------------------------------------------------